'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

exports.default = function (kibana) {
  return new kibana.Plugin({
    require: ['kibana', 'elasticsearch', 'saved_objects_api'],
    id: 'siren_export',

    uiExports: {
      hacks: ['plugins/siren_export/export_controller', 'plugins/siren_export/directive/siren_data_export']
    },

    init(server) {
      (0, _export2.default)(server);

      server.route({
        method: 'GET',
        path: '/iframe_export',
        handler: function (request, reply) {
          reply((0, _ui_iframe_form.iframeTemplate)());
        }
      });
    }

  });
};

var _export = require('./server/routes/export');

var _export2 = _interopRequireDefault(_export);

var _ui_iframe_form = require('./public/ui_iframe_form');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

; // it is a function as we use native module.exports

module.exports = exports['default'];
