Federate Resolver, is a central service that:
- Fetches the version of ES and federate we’re connected to and resolve compatibility.
- Have an internal compatibility matrix based on fixed names for new features/APIs (If it is an array, then the versions should match exactly and if string then anything over it should work).

### Feature/API Compatibility Matrix:
**Supported array (supported_federate_exceptions, supported_es_exceptions)**: Major and minor versions should match exactly, only higher patch release is allowed.
**Min version (min_federate, min_es)**: Anything over this version is allowed (Higher major, minor and patch releases. Subject to deprecation).
**Discontinued (max_federate, max_es)**: Backend equating to or higher than this version is NOT allowed.

Example:
```
{
 MODULE_DATASOURCE_REFLECTION: {
  min_federate: ‘6.3.2-10.2.0’,
  min_es: '6.3.2'
 },
 FEATURE_SCROLLAPIWITHJOINS_V1: {
  min_es: '6.5.4',// Anything over this version is allowed
  min_federate: '6.5.4-10.2.0',
  max_federate: ‘7.0.0-10.4.0’,// Backend equating to or higher than this version is NOT allowed
  max_es: '7.0.0',
  supported_federate_exceptions: [ ‘5.6.10-10.1.1’, ‘6.3.2-10.1.1’],// Versions should match exactly (higher patch release allowed)
  supported_es_exceptions: ['5.6.10', '6.3.2']
 },
 FEATURE_SCROLLAPIWITHJOINS_V2: {
  min_federate: ‘7.0.0-10.4.0’,
  min_es: '7.0.0'
 }
}
```

### Developing with the presence of a Federate Resolver:
- In order to prevent every module having to account for different versions of backend and a maintenance nightmare, it would be up to the federate resolver to automatically provide alternate implementations. It can either be done by implementing APIs in question and having other modules use them or using a sub-module dealing with different implementations, such as: If export procedure is to be changed based on backend then the entire implementations have to be defined inside federate resolver and the module would just call them. This is to have a clear separation for backend dependent code.
- External plugins (outside kibi-internal) are free to have implementations in their repositories (if deemed better) but backend dependent code should be separated into a separate module within them.
