'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
/**
 * Feature compatibility description:
 * {
 *  (Required) name: 'Module name',
 *  (Required) description: 'Describe what this functionality does',
 *  min_es: '6.5.4',// Anything over this version is allowed
 *  min_federate: '6.5.4-10.2.0',
 *  max_federate: ‘7.0.0-10.4.0’,// Backend equating to or higher than this version is NOT allowed
 *  max_es: '7.0.0',
 *  supported_federate_exceptions: [ ‘5.6.10-10.1.1’, ‘6.3.2-10.1.1’],// Exceptions, should be used sparingly. Versions should match exactly
 *  supported_es_exceptions: ['5.6.10', '6.3.2']
 * }
 */
const FEATURE_COMPATIBILITY_MATRIX = Object.freeze({
  MODULE_DATASOURCE_REFLECTION: {
    name: 'Datasource Reflection',
    description: 'Data Reflection enables the import and mapping of data to Elasticsearch from registered datasources.',
    min_federate: '6.5.4-10.2.0'
  },
  CONNECTOR_NEO4J: {
    name: 'Neo4j Compatibility',
    description: 'Ability to register a Neo4J datasource, which can be used in Data Reflection.',
    min_federate: '6.5.4-10.2.0'
  },
  REMOTE_ES_CONNECTOR: {
    name: 'Remote ES Connector',
    description: 'Ability to register a remote Elasticsarch cluster as a datasource and create virtual indices on it.',
    min_federate: '6.8.0-10.3.0'
  }
});

exports.default = FEATURE_COMPATIBILITY_MATRIX;
module.exports = exports['default'];
