"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
/**
 * Incompatible versions should always be negative.
 * Absolute value of higher support is always high, eg: value of TARGET > FEATURE_COMPLETE > MIN_SUPPORTED
 * @type {Number}
 */
const COMPATIBILITY_STATUS = Object.freeze({
  TOO_HIGH: -4,
  FEDERATE_NOT_FOUND: -3,
  INVALID_VERSION: -2,
  TOO_OLD: -1,
  MIN_SUPPORTED: 0,
  FEATURE_COMPLETE: 1,
  TARGET: 2
});

exports.default = COMPATIBILITY_STATUS;
module.exports = exports["default"];
