'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

exports.default = function (kibana) {
  return new kibana.Plugin({
    require: ['elasticsearch'],
    id: _package.name,
    uiExports: {
      hacks: ['plugins/federate_resolver'],
      injectDefaultVars: function () {
        return {
          federateCompatibilityMatrix: _utils.pkg.siren.compatibility
        };
      }
    },
    init(server, options) {
      const { callWithInternalUser } = server.plugins.elasticsearch.getCluster('admin');
      const h = `component,version`;
      callWithInternalUser('cat.plugins', {
        h,
        format: 'json'
      }).then(components => {
        const federateResolver = new _common.FederateResolver(components, _utils.pkg.siren.compatibility);
        server.expose('getFederateResolver', () => federateResolver);
        this.status.green('Initialized.');
      });
      this.status.yellow('Initializing.');
    }
  });
};

var _utils = require('../../utils');

var _common = require('./common');

var _package = require('./package.json');

module.exports = exports['default'];
