'use strict';

var _gremlin_server = require('../../server/gremlin_server/gremlin_server');

var _gremlin_server2 = _interopRequireDefault(_gremlin_server);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * The gremlin_server plugin checks the status of the gremlin server.
 */
module.exports = function (kibana) {

  return new kibana.Plugin({
    require: ['elasticsearch', 'kibana', 'migrations'],
    id: 'gremlin_server',

    init: function (server, options) {
      let gremlin;
      this.status.yellow('Waiting for the Siren Gremlin Server to start up.');

      const _config = server.config();
      const gremlinServerconfig = _config.get('investigate_core.gremlin_server');

      if (gremlinServerconfig) {
        gremlin = new _gremlin_server2.default(server);

        const loadGremlinServer = () => {
          const clean = function (code) {
            if (gremlin) {
              return gremlin.stop('gremlin_server plugin - clean function');
            } else {
              return Promise.resolve();
            }
          };
          gremlin.start('gremlin_server plugin').then(() => {
            this.status.green('Siren Gremlin Server is up and running.');
            this.kbnServer.cleaningArray.push(clean);
          }).catch(error => {
            this.status.red(error.message);
          });
        };

        const elasticsearchStatus = server.plugins.elasticsearch.status;
        const migrationsStatus = server.plugins.migrations.status;

        const handleStatusChange = () => {
          if (migrationsStatus && migrationsStatus.state === 'green' && elasticsearchStatus && elasticsearchStatus.state === 'green' && !gremlin.isInitialized()) {
            loadGremlinServer();
          } else if (elasticsearchStatus && elasticsearchStatus.state === 'red' && gremlin.isInitialized()) {
            this.status.red('Unable to connect to ElasticSsearch.');
            gremlin.stop('gremlin_server plugin - red elastic');
          }
        };

        if (elasticsearchStatus && elasticsearchStatus.state === 'green' && migrationsStatus && migrationsStatus.state === 'green') {
          loadGremlinServer();
        } else {
          elasticsearchStatus.on('change', () => {
            // eslint-disable-line memoryleaks
            handleStatusChange();
          });
          migrationsStatus.on('change', () => {
            // eslint-disable-line memoryleaks
            handleStatusChange();
          });
        }
      } else {
        this.status.red('Siren Gremlin Server configuration not found in investigate.yml, please configure it.');
      }
    }
  });
};
