'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _joi = require('joi');

var _joi2 = _interopRequireDefault(_joi);

var _boom = require('boom');

var _boom2 = _interopRequireDefault(_boom);

var _image_request = require('../lib/image_request.js');

var _image_cache = require('../lib/image_cache.js');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = server => {
  const serverConfig = server.config();
  const useImageCache = serverConfig.get('investigate_core.image_proxy.proxy_cache_enabled');
  const imageProxyCache = (0, _image_cache.imageCache)(serverConfig.get('investigate_core.image_proxy.proxy_cache_expiration') * 1000);
  server.route({
    path: '/image_proxy',
    config: {
      validate: {
        query: _joi2.default.object().keys({
          url: _joi2.default.string()
        })
      }
    },
    method: 'GET',
    handler: async (request, reply) => {
      const url = request.query.url;
      const browserCacheControl = serverConfig.get('investigate_core.image_proxy.browser_cache_control');
      const imageInCache = useImageCache ? imageProxyCache.get(url) : null;
      if (imageInCache) {
        reply(imageInCache.body).code(imageInCache.statusCode).header('Cache-Control', browserCacheControl).header('Content-Type', imageInCache.contentType).header('Content-Length', imageInCache.contentLength);
      } else {
        (0, _image_request.executeRequest)(url, serverConfig).then(response => {
          if (useImageCache) {
            imageProxyCache.set(url, response);
          }
          reply(response.body).code(response.statusCode).header('Cache-Control', browserCacheControl).header('Content-Type', response.contentType).header('Content-Length', response.contentLength);
        }).catch(error => {
          reply(_boom2.default.wrap(error, 400));
        });
      }
    }
  });
};

module.exports = exports['default'];
