'use strict';

var _http = require('http');

var _http2 = _interopRequireDefault(_http);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _package = require('./package.json');

var _package2 = require('../../../package.json');

var _patch_elasticsearch_client = require('./lib/elasticsearch/patch_elasticsearch_client');

var _migration_ = require('./lib/migrations/migrations_5/migration_1');

var _migration_2 = _interopRequireDefault(_migration_);

var _migration_3 = require('./lib/migrations/migrations_5/migration_2');

var _migration_4 = _interopRequireDefault(_migration_3);

var _migration_5 = require('./lib/migrations/migrations_5/migration_3');

var _migration_6 = _interopRequireDefault(_migration_5);

var _migration_7 = require('./lib/migrations/migrations_5/migration_4');

var _migration_8 = _interopRequireDefault(_migration_7);

var _migration_9 = require('./lib/migrations/migrations_5/migration_5');

var _migration_10 = _interopRequireDefault(_migration_9);

var _migration_11 = require('./lib/migrations/migrations_5/migration_7');

var _migration_12 = _interopRequireDefault(_migration_11);

var _migration_13 = require('./lib/migrations/migrations_5/migration_8');

var _migration_14 = _interopRequireDefault(_migration_13);

var _migration_15 = require('./lib/migrations/migrations_5/migration_9');

var _migration_16 = _interopRequireDefault(_migration_15);

var _migration_17 = require('./lib/migrations/migrations_5/migration_10');

var _migration_18 = _interopRequireDefault(_migration_17);

var _migration_19 = require('./lib/migrations/migrations_5/migration_11');

var _migration_20 = _interopRequireDefault(_migration_19);

var _migration_21 = require('./lib/migrations/migrations_5/migration_12');

var _migration_22 = _interopRequireDefault(_migration_21);

var _migration_23 = require('./lib/migrations/migrations_5/migration_13');

var _migration_24 = _interopRequireDefault(_migration_23);

var _migration_25 = require('./lib/migrations/migrations_5/migration_14');

var _migration_26 = _interopRequireDefault(_migration_25);

var _migration_27 = require('./lib/migrations/migrations_5/migration_15');

var _migration_28 = _interopRequireDefault(_migration_27);

var _migration_29 = require('./lib/migrations/migrations_5/migration_16');

var _migration_30 = _interopRequireDefault(_migration_29);

var _migration_31 = require('./lib/migrations/migrations_5/migration_17');

var _migration_32 = _interopRequireDefault(_migration_31);

var _migration_33 = require('./lib/migrations/migrations_5/migration_18');

var _migration_34 = _interopRequireDefault(_migration_33);

var _migration_35 = require('./lib/migrations/migrations_5/migration_19');

var _migration_36 = _interopRequireDefault(_migration_35);

var _migration_37 = require('./lib/migrations/migrations_5/migration_20');

var _migration_38 = _interopRequireDefault(_migration_37);

var _migration_39 = require('./lib/migrations/migrations_5/migration_21');

var _migration_40 = _interopRequireDefault(_migration_39);

var _migration_41 = require('./lib/migrations/migrations_5/migration_23');

var _migration_42 = _interopRequireDefault(_migration_41);

var _migration_43 = require('./lib/migrations/migrations_5/migration_24');

var _migration_44 = _interopRequireDefault(_migration_43);

var _migration_45 = require('./lib/migrations/migrations_5/migration_25');

var _migration_46 = _interopRequireDefault(_migration_45);

var _migration_47 = require('./lib/migrations/migrations_5/migration_26');

var _migration_48 = _interopRequireDefault(_migration_47);

var _migration_49 = require('./lib/migrations/migrations_5/migration_27');

var _migration_50 = _interopRequireDefault(_migration_49);

var _migration_51 = require('./lib/migrations/migrations_5/migration_28');

var _migration_52 = _interopRequireDefault(_migration_51);

var _migration_53 = require('./lib/migrations/migrations_5/migration_29');

var _migration_54 = _interopRequireDefault(_migration_53);

var _migration_55 = require('./lib/migrations/migrations_5/migration_30');

var _migration_56 = _interopRequireDefault(_migration_55);

var _migration_57 = require('./lib/migrations/migrations_5/migration_31');

var _migration_58 = _interopRequireDefault(_migration_57);

var _migration_59 = require('./lib/migrations/migrations_5/migration_32');

var _migration_60 = _interopRequireDefault(_migration_59);

var _migration_61 = require('./lib/migrations/migrations_5/migration_33');

var _migration_62 = _interopRequireDefault(_migration_61);

var _migration_63 = require('./lib/migrations/migrations_5/migration_34');

var _migration_64 = _interopRequireDefault(_migration_63);

var _migration_65 = require('./lib/migrations/migrations_6/migration_36');

var _migration_66 = _interopRequireDefault(_migration_65);

var _migration_67 = require('./lib/migrations/migrations_6/migration_37');

var _migration_68 = _interopRequireDefault(_migration_67);

var _migration_69 = require('./lib/migrations/migrations_6/migration_38');

var _migration_70 = _interopRequireDefault(_migration_69);

var _migration_71 = require('./lib/migrations/migrations_6/migration_39');

var _migration_72 = _interopRequireDefault(_migration_71);

var _migration_73 = require('./lib/migrations/migrations_6/migration_40');

var _migration_74 = _interopRequireDefault(_migration_73);

var _migration_75 = require('./lib/migrations/migrations_6/migration_41');

var _migration_76 = _interopRequireDefault(_migration_75);

var _migration_77 = require('./lib/migrations/migrations_6/migration_42');

var _migration_78 = _interopRequireDefault(_migration_77);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * The Investigate core plugin.
 *
 */

// migration 6 removed as no longer needed as we added a build-in model of url object to savedObjectsAPI
module.exports = function (kibana) {

  const migrations = [_migration_2.default, _migration_4.default, _migration_6.default, _migration_8.default, _migration_10.default, _migration_12.default, _migration_14.default, _migration_16.default, _migration_18.default, _migration_20.default, _migration_22.default, _migration_24.default, _migration_26.default, _migration_28.default, _migration_30.default, _migration_32.default, _migration_34.default, _migration_36.default, _migration_38.default, _migration_40.default, _migration_42.default, _migration_44.default, _migration_46.default, _migration_48.default, _migration_50.default, // gremlin used
  _migration_52.default, // gremlin used
  _migration_54.default, // gremlin used
  _migration_56.default, _migration_58.default, _migration_60.default, _migration_62.default, // gremlin used
  _migration_64.default, _migration_66.default, _migration_68.default, _migration_70.default, // gremlin used
  _migration_72.default, _migration_74.default, _migration_76.default, _migration_78.default];

  return new kibana.Plugin({
    require: ['kibana', 'elasticsearch'],

    id: _package.name,

    uiExports: {
      hacks: ['plugins/investigate_core/restore', 'plugins/investigate_core/ui/directives/dashboards_nav/dashboards_nav', 'plugins/investigate_core/ui/chrome/services/dashboards_nav_state', 'plugins/investigate_core/saved_objects/dashboard_groups/saved_dashboard_groups', 'plugins/investigate_core/ui/services/dashboard_groups', 'plugins/investigate_core/ui/directives/dashboard_button/dashboard_button', 'plugins/investigate_core/api/api', 'ui/kibi/components/ontology_model/ontology_model'],
      managementSections: ['plugins/investigate_core/management/sections/data_model', 'plugins/investigate_core/management/sections/kibi_virtual_indices', 'plugins/investigate_core/management/sections/kibi_datasources', 'plugins/investigate_core/management/sections/kibi_queries', 'plugins/investigate_core/management/sections/kibi_templates', 'plugins/investigate_core/management/sections/scripts', 'plugins/investigate_core/management/sections/relational_graphs'],
      navbarExtensions: ['plugins/investigate_core/management/sections/navbar', 'plugins/investigate_core/dashboard/navbar'],
      spyModes: ['plugins/investigate_core/ui/spy_modes/multi_search_spy_mode'],
      injectDefaultVars: function (server, options) {
        const vars = {};

        // Where: options = investigate_core piece of configuration
        if (options) {
          vars.kibiWarnings = {};
          if (options.datasource_encryption_key === 'iSxvZRYisyUW33FreTBSyJJ34KpEquWznUPDvn+ka14=') {
            vars.kibiWarnings.datasource_encryption_warning = true;
          }
        }

        return vars;
      }
    },

    config: function (Joi) {
      return Joi.object({
        enabled: Joi.boolean().default(true),

        load_jdbc: Joi.boolean().default(false),
        clusterplugins: Joi.any(),

        elasticsearch: Joi.object({
          auth_plugin: Joi.string().allow('').default('')
        }),
        gremlin_server: Joi.object({
          log_conf_path: Joi.string().allow('').default(''),
          debug_remote: Joi.string().allow('').default(''),
          path: Joi.string().default('gremlin_server/gremlin-server.jar'),
          url: Joi.string().uri({ scheme: ['http', 'https'] }).default('http://127.0.0.1:8061'),
          quiet: Joi.boolean().default(false),
          ssl: Joi.object({
            key_store: Joi.string(),
            key_store_password: Joi.string(),
            ca: Joi.string()
          }).default()
        }).default(),
        image_proxy: Joi.object({
          enabled: Joi.boolean().default(true),
          max_image_size: Joi.number().default(10000),
          allowed_domains: Joi.array().items().single().default('*'),
          timeout: Joi.number().default(30000),
          proxy_cache_enabled: Joi.boolean().default(false),
          proxy_cache_expiration: Joi.number().default(3600),
          browser_cache_control: Joi.string().default('public, max-age=3600')
        }).default(),

        datasource_encryption_algorithm: Joi.string().default('AES-GCM'),
        datasource_encryption_key: Joi.string().default('iSxvZRYisyUW33FreTBSyJJ34KpEquWznUPDvn+ka14='),

        datasource_cache_size: Joi.number().default(500),

        // kibi: it is left for logging deprecated message in init function
        default_dashboard_title: Joi.string().allow('').default('')
      }).default();
    },

    preInit: function (server, kbnServer) {
      // Expose the migrations on kbnServer
      kbnServer.migrations.investigate_core = migrations;
    },

    init: function (server, options) {
      const config = server.config();

      (0, _patch_elasticsearch_client.patchElasticsearchClient)(server);

      if (config.get('investigate_core.default_dashboard_title') !== '') {
        server.log(['warning', 'investigate_core'], 'investigate_core.default_dashboard_title is deprecated ' + 'and was moved to advance settings and should be removed from investigate.yml');
      }

      // Adding a route to serve static content for enterprise modules.
      server.route({
        method: 'GET',
        path: '/static/{param*}',
        handler: {
          directory: {
            path: _path2.default.normalize(__dirname + '../../../plugins/')
          }
        }
      });

      // Adding a route to return the list of installed Elasticsearch plugins
      // Route takes an optional parameter of the string "version"
      // If "version" is present, the plugins are returned as an array of objects
      // containing 'component' (plugin name) and 'version'
      // If version is absent, an array of the plugin names are returned
      server.route({
        method: 'GET',
        path: '/getElasticsearchPlugins/{version?}',
        handler: function (request, reply) {
          // here we use admin cluster to make sure the _cat/plugins
          // will work even if it is a tribe cluster
          const { callWithInternalUser } = server.plugins.elasticsearch.getCluster('admin');
          const h = `component${request.params.version && request.params.version === 'versions' ? ',version' : ''}`;
          return callWithInternalUser('cat.plugins', {
            h,
            format: 'json'
          }).then(components => {
            if (!(request.params.version && request.params.version === 'versions')) {
              components = components.map(component => component.component);
            }

            return reply(components);
          });
        }
      });

      server.route({
        method: 'GET',
        path: '/elasticsearchVersion',
        handler: function (request, reply) {
          // here we use admin cluster to make sure the _cat/plugins
          // will work even if it is a tribe cluster
          const { callWithInternalUser } = server.plugins.elasticsearch.getCluster('admin');

          return callWithInternalUser('nodes.info', {
            filterPath: ['nodes.*.version']
          }).then(info => {
            const versions = Object.keys(info.nodes).map(nodeKey => info.nodes[nodeKey].version);

            return reply(versions);
          });
        }
      });

      server.route({
        method: 'GET',
        path: '/api/investigate_version',
        handler: function (request, reply) {
          return reply(_package2.kibi_version);
        }
      });
    }

  });
};
// Migration 36 is meant to run only on objects in new ES 6 format

// Migration33 is the index migration which clears and re-created siren index.
