'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkESVersion = checkESVersion;
async function checkESVersion(server) {
  const { callWithInternalUser } = server.plugins.elasticsearch.getCluster('admin');
  return callWithInternalUser('cat.nodes', { h: 'version', format: 'json' }).then(nodeList => {
    let elasticsearchVersion;
    for (let i = 0; i < nodeList.length; i++) {
      elasticsearchVersion = nodeList[i].version;
      break;
    }

    const params = elasticsearchVersion.split(/\./g);
    const major = parseInt(params[0]);
    const minor = parseInt(params[1]);

    return { major, minor };
  });
};
