'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = n3ModelToJson;
const N3 = require('n3');

function n3ModelToJson(model) {

  return new Promise(function (resolve, reject) {
    const triples = [];
    const parser = N3.Parser(); // eslint-disable-line new-cap
    parser.parse(model, function (error, triple, prefixes) {
      if (error) {
        reject(error);
      }
      if (triple) {
        if (N3.Util.isLiteral(triple.object)) {
          triple.object = N3.Util.getLiteralValue(triple.object);
        }
        triples.push({
          s: triple.subject,
          p: triple.predicate,
          o: triple.object
        });
      } else {
        resolve(triples);
      }
    });
  });
};
module.exports = exports['default'];
