/*

  This is a MODIFIED copy of create index pattern controller
  as the requirement was to allow index-pattern edition from
  Data Model page

  Instead of creating new index pattern this controller has to
  gather changes and then on submit:
  - delete the existing index pattern object
  - create a new one
  - update references to this new object inside current Search Entity
*/

import _ from 'lodash';
import angular from 'angular';
import { IndexPatternMissingIndices, NoAccessToFieldStats } from 'ui/errors';
import 'ui/directives/validate_index_name';
import 'ui/directives/auto_select_if_only_one';
// kibi: removed RefreshKibanaIndex as in Kibi refresh is done by saved object API

import uiRoutes from 'ui/routes';
import { uiModules } from 'ui/modules';
import { getDefaultPatternForInterval } from
  'plugins/kibana/management/sections/indices/create_index_pattern/get_default_pattern_for_interval';
import { sendCreateIndexPatternRequest } from
  'plugins/kibana/management/sections/indices/create_index_pattern/send_create_index_pattern_request';
import { pickCreateButtonText } from 'plugins/kibana/management/sections/indices/create_index_pattern/pick_create_button_text';

// kibi: imported IndexPatternAuthorizationError
import uuid from 'uuid';
import { IndexPatternAuthorizationError } from 'ui/errors';
import { EntityType } from 'ui/kibi/components/ontology/entity_type';
import { DataModelErrorType } from 'plugins/investigate_core/management/sections/data_model/controllers/error_type';
import { SavedObjectsClientProvider } from 'ui/saved_objects';
// kibi: imports end

uiModules
  .get('apps/management', ['kibana'])
  .controller('EditIndexPatternSearchController', function ($scope, $routeParams, kbnUrl, Private, Notifier, indexPatterns,
    es, config, Promise, $translate, confirmModal, savedSearches, courier, dataModel) {
    const notify = new Notifier({
      location: 'Edit index pattern search'
    });
    // kibi: removed RefreshKibanaIndex as in Investigate refresh is done by saved object API
    const intervals = indexPatterns.intervals;
    let loadingCount = 0;

    this.formValues = {
      name: $scope.errorRecoveredIndexPatternAttributes ? $scope.errorRecoveredIndexPatternAttributes.title : '',
      nameIsPattern: false,
      expandWildcard: false,
      nameInterval: _.find(intervals, { name: 'daily' }),
      timeFieldOption: $scope.errorRecoveredIndexPatternAttributes ? $scope.errorRecoveredIndexPatternAttributes.timeFieldName : null,
      excludeIndices: true
    };

    // kibi: modified populate based on scope indexPattern
    $scope.$watch('indexPattern', indexPattern => {
      if (indexPattern) {
        this.formValues.id = indexPattern.id; // we do not allow to change it in the html form
        this.formValues.name = indexPattern.title;
        this.formValues.excludeIndices = indexPattern.excludeIndices;
      }
    });

    // Note:
    // When validator set field value to invalid but it was not yet touched by the user
    // the css rule will prevent rendering the input red
    // We can fix this by programatically setting it to $touched
    $scope.$watch('ipController.form.$valid', (valid) => {
      if (!valid && this.form) {
        angular.forEach(this.form.$error, function (field) {
          field[0].$setTouched();
        });
      }
    });

    $scope.isWildcard = indexPattern => indexPattern && indexPattern.includes('*');

    const savedObjectsClient = Private(SavedObjectsClientProvider);

    this.onPatternChange = () => {
      if (this.formValues.name === undefined) {
        $scope.$emit('indexPatternLabelEmpty',  true);
      } else {
        $scope.$emit('indexPatternLabelEmpty',  false);
      }
      this.formValues.classLabel = this.formValues.name;

      $scope.indexPatternError = this.indexPatternError = null;

      this.refreshTimeFieldOptions();

      if (!$scope.indexPatternError) {
        dataModel.findIndexPatternSearchByPattern({ indexPropertiesName: this.formValues.name, silent: true })
          .then(search => {
            if (search.length && search[0].indexPattern !== this.formValues.id) {
              $scope.indexPatternError = this.indexPatternError =
              `There is already a search using this index pattern: ${search[0].label}`;
            }
          });
      }
    };
    // kibi: end

    // UI state.
    this.timeFieldOptions = [];
    this.indexPatternError = null;
    this.nameIntervalOptions = intervals;
    this.patternErrors = [];

    this.showAdvancedOptions = false;

    // kibi: removed resetIndex moreSamples and updateSamples functions as in Kibana 6.0.0

    this.isTimeBased = () => {
      if (!this.formValues.timeFieldOption) {
      // if they haven't choosen a time field, assume they will
        return true;
      }

      // if timeFieldOption has a fieldName it's a time field, otherwise
      // it's a way to opt-out of the time field or an indication that there
      // are no fields available
      return Boolean(this.formValues.timeFieldOption.fieldName);
    };

    this.canEnableExpandWildcard = () => {
      return (
        this.isTimeBased() &&
        !this.isCrossClusterName() &&
        !this.formValues.nameIsPattern &&
        _.includes(this.formValues.name, '*')
      );
    };

    this.isExpandWildcardEnabled = () => {
      return (
        this.canEnableExpandWildcard() &&
        !!this.formValues.expandWildcard
      );
    };

    this.canUseTimePattern = () => {
      return (
        this.isTimeBased() &&
        !this.isExpandWildcardEnabled() &&
        !this.isCrossClusterName()
      );
    };

    this.isCrossClusterName = () => {
      return (
        this.formValues.name &&
        this.formValues.name.includes(':')
      );
    };

    this.isLoading = () => loadingCount > 0;

    let activeRefreshTimeFieldOptionsCall;
    this.refreshTimeFieldOptions = () => {
    // skip if no pattern
      if (!this.formValues.name || $scope.selectedTab !== 'info') {
        return;
      }

      // if there is an active refreshTimeFieldOptions() call then we use their prevOption, allowing the previous
      // selection to persist across simultaneous calls to refreshTimeFieldOptions()
      const prevOption = activeRefreshTimeFieldOptionsCall ? activeRefreshTimeFieldOptionsCall.prevOption : this.formValues.timeFieldOption;

      // if there is an active refreshTimeFieldOptions() call then we use their prevOption, allowing the previous
      // selection to persist across simultaneous calls to refreshTimeFieldOptions()
      const thisCall = activeRefreshTimeFieldOptionsCall = { prevOption };

      ++loadingCount;
      this.timeFieldOptions = [];
      this.formValues.timeFieldOption = null;
      indexPatterns.getTimeFieldOptions(this.formValues.name, this.formValues.nameIsPattern)
        .then(({ options, error }) => {
          if (thisCall !== activeRefreshTimeFieldOptionsCall) return;

          this.timeFieldOptions = options;
          if (error) {
            $scope.indexPatternError = this.indexPatternError = error;
          }

          if (!this.timeFieldOptions) {
            return;
          }

          if (!thisCall.prevOption && $scope.indexPattern && $scope.indexPattern.timeFieldName) {
          // no previous option try to select based on indexPattern
            const found = _.find(this.timeFieldOptions, option => {
              return option.fieldName === $scope.indexPattern.timeFieldName;
            });
            if (found) {
              this.formValues.timeFieldOption = found;
            } else {
              this.formValues.timeFieldOption = this.timeFieldOptions[0];
            }
          } else if (!thisCall.prevOption &&  (!$scope.indexPattern || !$scope.indexPattern.timeFieldName)) {
            this.formValues.timeFieldOption = this.timeFieldOptions.filter(option => !option.fieldName)[0];
          } else {
          // Restore the previously selected state, or select the default option in the UI
            const restoredOption = this.timeFieldOptions.some(option => option.fieldName === prevOption.fieldName) ? prevOption : undefined;
            const defaultOption = indexPatterns.pickDefaultTimeFieldOption(this.timeFieldOptions);
            this.formValues.timeFieldOption = restoredOption || defaultOption;
          }
        })
        .catch(err => notify.error(err))
        .finally(() => {
          --loadingCount;
          if (thisCall === activeRefreshTimeFieldOptionsCall) {
            activeRefreshTimeFieldOptionsCall = null;
          }
        });
    };

    $scope.$watch('selectedTab', selectedTab => {
      if (selectedTab === 'info' && !activeRefreshTimeFieldOptionsCall && this.formValues.name) {
        this.refreshTimeFieldOptions();
      }
    });

    $scope.$watch('indexPatternError', () => $scope.$emit('indexPatternError',  this.indexPatternError));

    this.updateIndexPattern = () => {
      if (
        $scope.entity.parentId === null &&
      $scope.entity.type === EntityType.SAVED_SEARCH &&
      this.form &&
      this.form.$dirty &&
      this.form.$valid
      ) {
        if ($scope.entity._objects.errorType === DataModelErrorType.INDEX_PATTERN_MISSING_DATA_INDICES) {
          return this.createIndexPattern($scope.entity.indexPattern)
            .then(indexPatternId => indexPatterns.get(indexPatternId))
            .then(indexPattern => {
              $scope.entity.indexPattern = indexPattern.id;
              $scope.indexPattern = indexPattern;
              $scope.entity._objects.indexPattern = indexPattern;
              if ($scope.savedSearch) {
                $scope.savedSearch.searchSource.set('index', indexPattern);
              }
            });
        }
        return indexPatterns.get($scope.entity.indexPattern)
          .then((indexPattern) => {
            // kibi: if index pattern title is the same, then don't recreate the index pattern, just update it
            if (this.formValues.name === indexPattern.title) {
              indexPattern.timeFieldName = _.get(this, 'formValues.timeFieldOption.fieldName');
              indexPattern.excludeIndices = this.formValues.excludeIndices;
              return indexPattern.save();
            } else {
              return this.deleteIndexPattern()
                .then(() => this.createIndexPattern($scope.entity.indexPattern))
                .then(indexPatternId => indexPatterns.get(indexPatternId))
                .then(indexPattern => {
                  $scope.entity.indexPattern = indexPattern.id;
                  $scope.indexPattern = indexPattern;
                  $scope.entity._objects.indexPattern = indexPattern;
                  if ($scope.savedSearch) {
                    $scope.savedSearch.searchSource.set('index', indexPattern);
                  }
                });
            }
          });
      }
    };

    const toRegister = () => {
    // here closure and arrow function to correctly bind the this
      this.updateIndexPattern();
    };

    dataModel.registerBeforeSave(toRegister);

    $scope.$on('$destroy', function () {
      dataModel.deregisterBeforeSave(toRegister);
    });

    this.deleteIndexPattern = () => {
    // Note:
    // Special case underlying data index was removed
    //
    // delete the old one we use the savedObjectClient
    // as it is imposible to delete the object using indexPattern object itself when
    // we could NOT create it in the first place
    //
    // as we are using savedObjectClient direclty
    // take care and unset the defaultIndex

      const id = $scope.entity.indexPattern;
      if (config.get('defaultIndex') === id) {
        config.set('defaultIndex', '');
      }
      return savedObjectsClient.delete('index-pattern', id);
    };
    // kibi: end

    this.createIndexPattern = (previousId = null) => {
      const {
        name,
        timeFieldOption,
        nameIsPattern,
        nameInterval,
        excludeIndices,
        // kibi: added following new properties
        classLabel,
        shortDescription,
        longDescription,
        icon,
        color
      } = this.formValues;

      const timeFieldName = timeFieldOption
        ? timeFieldOption.fieldName
        : undefined;

      const notExpandable = this.isExpandWildcardEnabled()
        ? undefined
        : true;

      // Only event-time-based index patterns set an intervalName.
      const intervalName = (this.canUseTimePattern() && nameIsPattern && nameInterval)
        ? nameInterval.name
        : undefined;

      // kibi: there must be an id so use the one provided by the user or name
      const idToCreate = previousId ? previousId : uuid.v1();
      // kibi: end

      const skipOverwrite = true;
      return indexPatterns.getIds()
        .then(indexPatternIds => {
          return sendCreateIndexPatternRequest(
            indexPatterns,
            {
              id: idToCreate,
              name,
              timeFieldName,
              intervalName,
              notExpandable,
              excludeIndices
            },
            skipOverwrite
          ).then(createdId => {
            if (!createdId) {
              return;
            }

            // kibi: removed RefreshKibanaIndex as in Investigate refresh is done by saved object API
            // kibi: do not try to set the default index pattern automatically
            // as user might not have permissions to do it

            indexPatterns.cache.clear(createdId);

            // If there are no other indexpatterns, set this one as the preferred one
            if (!indexPatternIds.length) {
              config.set('defaultIndex', createdId);
            }

            // force loading while kbnUrl.change takes effect
            loadingCount = Infinity;
            return createdId;
          }).catch(err => {
            if (err instanceof IndexPatternMissingIndices) {
              return notify.error('Could not locate any indices matching that pattern. Please add the index to Elasticsearch');
            }

            notify.fatal(err);
          });

        });
    };

    $scope.$watchMulti([
      'ipController.formValues.nameIsPattern',
      'ipController.formValues.nameInterval.name',
    ], (newVal, oldVal) => {
      const nameIsPattern = newVal[0];
      const newDefault = getDefaultPatternForInterval(newVal[1]);
      const oldDefault = getDefaultPatternForInterval(oldVal[1]);

      if (this.formValues.name === oldDefault) {
        this.formValues.name = newDefault;
      }

      if (!nameIsPattern) {
        delete this.formValues.nameInterval;
      } else {
        this.formValues.nameInterval = this.formValues.nameInterval || intervals.byName.days;
        this.formValues.name = this.formValues.name || getDefaultPatternForInterval(this.formValues.nameInterval);
      }
    });

    // kibi: removed watches on nameInterval, nameIsPattern and sampleCount as in Kibana 6.0.0
    $scope.$watch('ipController.formValues.name', () => {
      if ($scope.ipController.formValues.name) {
        if (!activeRefreshTimeFieldOptionsCall && $scope.selectedTab === 'info') {
          this.refreshTimeFieldOptions();
        }
      } else {
        this.indexPatternError = null;
        this.timeFieldOptions = [];
      }
    });

    $scope.$watchMulti([
      'ipController.isLoading()',
      'ipController.form.name.$error.indexNameInput',
      'ipController.formValues.timeFieldOption'
    ], ([loading, invalidIndexName, timeFieldOption]) => {
      const state = { loading, invalidIndexName, timeFieldOption };
      this.createButtonText = pickCreateButtonText($translate, state);
    });



  });
