import _ from 'lodash';
import { EntityType } from 'ui/kibi/components/ontology/entity_type';
import { OntologyWrapperProvider } from 'ui/kibi/quick_relations/ontology_wrapper';

export function EntityValidatorProvider(Private, indexPatterns, savedSearches, ontologyModel, createNotifier) {
  ontologyModel = Private(OntologyWrapperProvider).forOntologyModel(ontologyModel);

  const notify = createNotifier({
    location: 'Entity validator'
  });

  class EntityValidator {

    /*
     * Finds the first valid entity. Only entities of the passed type (if any) will be valid.
     */
    findFirstValidEntity(entityType) {
      return Promise.all([
        indexPatterns.getIds(),
        savedSearches.find(),
        ontologyModel.getEntityList()
      ])
        .then(([ indexPatternIds, searches, entities ]) => {
        // We filter out search entities which we don't have a permission to access
          let permittedEntities = _.filter(entities, entity => {
            if (entity.type !== EntityType.SAVED_SEARCH) {
              return true;
            } else if (entity.indexPattern && entity._objects.indexPattern && entity._objects.savedSearch) {
              return true;
            }
            return false;
          });

          // We sort - as we prefer to get the first one of type SAVED_SEARCH as first if possible
          permittedEntities = _.sortByAll(permittedEntities, 'type', 'label');

          // return entities to avoid extra query
          return {
            entity: permittedEntities[0],
            permittedEntities,
            searches,
            indexPatternIds
          };
        });
    }
  }


  return new EntityValidator();
}

