import { uiModules } from 'ui/modules';

function controller($scope, kbnUrl, dataModel) {
  const self = this;
  self.processing = false;

  // Default Value
  self.formValues = {
    icon: 'fas fa-circle'
  };

  self.createEntityIdentifier = function () {
    const {
      label,
      shortDescription,
      longDescription,
      icon,
      color
    } = self.formValues;
    if (self.processing) {
      return;
    }
    self.processing = true;

    const entity = { label, shortDescription, longDescription, icon, color };

    return dataModel.createEntityIdentifier(entity)
      .then(id => {
        self.processing = false;
        kbnUrl.change(`/management/siren/datamodel/VIRTUAL_ENTITY/${id}`);
      });
  };
}

uiModules
  .get('apps/management', ['kibana'])
  .controller('VirtualEntityCreateController', controller);
