import { each } from "lodash";
import { DatasourceTypes } from 'plugins/investigate_core/management/sections/kibi_datasources/lib/datasources';

export const jdbcDatasourceTranslate = {

  savedDatasourceToJdbcDatasource: function (savedDatasource) {
    if (savedDatasource.datasourceType === DatasourceTypes.ELASTIC) {
      return {
        _id: savedDatasource.title,
        _source: {
          elastic: {
            alias: savedDatasource.title
          }
        }
      };
    }
    return {
      _id: savedDatasource.title,
      _source: {
        jdbc: this.savedDatasourceParamsToJdbcDatasourceParams(savedDatasource.datasourceParams)
      }
    };
  },

  /**
   * Converts the passed datasoucre to saved datasource
   * @param  {Object} datasource
   * @return {Object}
   */
  datasourceToSavedDatasource: function (datasource) {
    if (datasource._source.elastic) {
      return {
        id: datasource._id,
        title: datasource._id,
        datasourceType: DatasourceTypes.ELASTIC,
        datasourceParams: {},
        url: `#/management/siren/datasources/${datasource._id}`
      };
    } else {
      return {
        id: datasource._id,
        title: datasource._id,
        datasourceType: DatasourceTypes.JDBC,
        datasourceParams: this.jdbcDatasourceParamsToSavedDatasourceParams(datasource._source.jdbc),
        url: `#/management/siren/datasources/${datasource._id}`
      };
    }
  },

  savedDatasourceParamsToJdbcDatasourceParams: function (savedParams) {
    const propertiesObject = {};
    each(savedParams.properties, function (prop) {
      propertiesObject[prop.key] = prop.value;
    });
    return {
      username: savedParams.username,
      password: savedParams.password,
      timezone: savedParams.timezone,
      driver: savedParams.drivername,
      url: savedParams.connection_string,
      properties: propertiesObject
    };
  },

  jdbcDatasourceParamsToSavedDatasourceParams: function (jdbcParams) {
    const propertiesArray = [];
    if (jdbcParams.properties) {
      each(Object.keys(jdbcParams.properties), function (key) {
        propertiesArray.push({
          key: key,
          value: jdbcParams.properties[key]
        });
      });
    }
    return {
      username: jdbcParams.username,
      password: jdbcParams.password,
      timezone: jdbcParams.timezone,
      drivername: jdbcParams.driver,
      connection_string: jdbcParams.url,
      properties:  propertiesArray
    };
  }
};
