import _ from 'lodash';
import 'ui/notify';
import { uiModules } from 'ui/modules';

uiModules
  .get('relational_graphs/services/saved_relational_graphs',  [
    'kibana/notify',
    'kibana/courier'
  ])
  .factory('SavedRelationalGraph', function (courier, Private) {
    _.class(SavedRelationalGraph).inherits(courier.SavedObject);

    function SavedRelationalGraph(id) {
      courier.SavedObject.call(this, {
        type: SavedRelationalGraph.type,

        id: id,

        mapping: {
          title: 'string',
          model:  'json',
          version: 'integer'
        },

        defaults: {
          title: 'New Relation Graph',
          version: 1,
          model: '{}'
        },

        searchSource: false,

        init: function () {
          for (const attr of ['model']) {
            if (_.isString(this[attr])) {
              this[attr] = JSON.parse(this[attr]);
            }
          }
        }
      });
    }

    SavedRelationalGraph.type = 'relational-graph';

    // Order these fields to the top, the rest are alphabetical
    SavedRelationalGraph.fieldOrder = ['title'];

    return SavedRelationalGraph;
  });
