import './_saved_script';
import { uiModules } from 'ui/modules';
import { CacheProvider } from 'ui/kibi/helpers/cache_helper';
import SavedScriptLoader from './saved_script_loader';
import { savedObjectManagementRegistry } from 'plugins/kibana/management/saved_object_registry';

// Register this service with the saved object registry so it can be
// edited by the object editor.
savedObjectManagementRegistry.register({
  service: 'savedScripts',
  title: 'scripts'
});

// This is the only thing that gets injected into controllers
uiModules
  .get('plugins/graph_browser_vis/settings/saved_scripts')
  .service('savedScripts', function (Private, SavedScript, kbnIndex, kbnUrl, $http) {

    const options = {
      caching: {
        find: true,
        get: true,
        cache: Private(CacheProvider)
      },
      $http
    };
    const savedScriptLoader = new SavedScriptLoader(SavedScript, kbnIndex, kbnUrl, options);

    savedScriptLoader.urlFor = function (id) {
      return kbnUrl.eval('#/management/siren/objects/savedScripts/{{id}}', { id: id });
    };

    return savedScriptLoader;
  });
