import _ from 'lodash';
import Promise from 'bluebird';
import { uiModules } from 'ui/modules';
import { EntityType } from 'ui/kibi/components/ontology/entity_type';
import './siren_entity_nav.less';
import 'ui/kibi/components/ontology_model/ontology_model';
import 'angular-ui-tree';
import { SirenEntityNavResizeHelper } from 'ui/kibi/helpers/siren_entity_nav_resize_helper';
import { entityNavigator } from './component/siren_entity_nav_react';

uiModules
  .get('kibana')
  .directive('sirenEntityNav', function ($timeout) {
    return {
      restrict: 'E',
      scope: {
        entities: '=',
        selectedEntity: '=',
        resizable: '=',
        foldable: '=',
        changeSelectedEntity: '&',
        entityTypeToShow: '=?', // ALL, SAVED_SEARCH, VIRTUAL_ENTITY
        showChildren: '=?',
        hideIndexPattern: '=?',
        refreshOn: '=?'
      },

      link($scope, $element, attrs) {
        const container = $element[0];

        function render() {
          entityNavigator(container,
            $scope.$parent,
            $scope.foldable,
            $scope.selectedEntity,
            $scope.entities,
            $scope.entityTypeToShow,
            $scope.showChildren,
            $scope.changeSelectedEntity,
            $scope.hideIndexPattern
          );
        }

        render();

        const sirenEntityNavResize = new SirenEntityNavResizeHelper($scope.resizable);

        if ($scope.refreshOn) {
          $scope.$on($scope.refreshOn, () => {
            $timeout()                        // Binding expressions calculated in digest, after timeout
              .then(() => $timeout(render));    // Wait for next apply() block and render
          });
        }

        $scope.$on('$destroy', () => {
          if (sirenEntityNavResize && sirenEntityNavResize.destroy) {
            sirenEntityNavResize.destroy();
          };
        });

      }
    };
  });
