export function previewFittedSizeHelper(qtipApi, document, el) {
  const clientWidth = document.width();
  const clientHeight = document.height();
  const tooltip = qtipApi.tooltip;
  const contentWidth = tooltip.offset().left + tooltip.width();
  const tableContainer = tooltip.find('.qtip-content');
  const tableWithContent = tableContainer.find('table');
  // apply tooltip on the right if the list goes out of the window
  if (contentWidth > clientWidth) {
    tooltip.css('right', '0px');
  };
  // apply position of the table if the content is wider than container
  if (tableWithContent.width() > tableContainer.width()) {
    tableWithContent.css('table-layout', 'fixed').css('width', '100%');
  };
  const contentHeight = tooltip.offset().top + tooltip.height();
  // apply tooltip on the top if the list is too long
  if (tooltip.offset().top < 0 || contentHeight > clientHeight) {
    tooltip.css('top', '0px');
  };
  // recalculate position of the tip if tips's position is incorrect
  const linkTopCenteredPosition = el.offset().top + el.height() / 2;
  const tipTopPosition = tooltip.find('.qtip-tip').offset().top;
  if (tipTopPosition > linkTopCenteredPosition) {
    const newTipTopPosition = linkTopCenteredPosition - tooltip.offset().top;
    tooltip.find('.qtip-tip').css('top', newTipTopPosition + 'px');
  };
};