'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _lodash = require('lodash');

var _fs = require('fs');

var _path = require('path');

class DatasourcesSchema {
  constructor() {
    const datasourceSchemaPath = process.env.KIBI_SCHEMA_PATH ? process.env.KIBI_SCHEMA_PATH : (0, _path.join)(__dirname, 'datasources_schema.json');
    this._schemas = JSON.parse((0, _fs.readFileSync)(datasourceSchemaPath, 'utf8'));
  }

  setSchemas(schemas) {
    const prev = this._schemas;
    this._schemas = schemas;
    return prev;
  }

  getSchema(type) {
    const schema = this._schemas && this._schemas[type];

    if (!schema) {
      throw new Error(`Could not get schema for datasource type: ${type}.`);
    }

    return schema;
  }

  toInjectedVar() {
    const vars = {
      rest: this.getSchema('rest'),
      mysql: this.getSchema('mysql'),
      postgresql: this.getSchema('postgresql'),
      sparql_http: this.getSchema('sparql_http'),
      jdbc_new: this.getSchema('jdbc_new')
    };
    return Object.freeze(vars);
  }
}

exports.default = new DatasourcesSchema();
module.exports = exports['default'];
