'use strict';

var _url = require('url');

var _url2 = _interopRequireDefault(_url);

var _bluebird = require('bluebird');

var _bluebird2 = _interopRequireDefault(_bluebird);

var _query_helper = require('./query_helper');

var _query_helper2 = _interopRequireDefault(_query_helper);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function RulesHelper(server) {
  this.queryHelper = new _query_helper2.default(server);
}

RulesHelper.prototype.evaluate = function (rules, { selectedDocuments, credentials }) {
  const self = this;
  // for now there should be only 1 selectedDocument
  if (selectedDocuments.length > 1) {
    return _bluebird2.default.reject(new Error('RulesHelper supports only 1 selected document at the moment'));
  }

  const { index, type, id } = selectedDocuments[0];

  return self.queryHelper.fetchDocument(index, type, id, credentials).then(function (doc) {

    for (let i = 0; i < rules.length; i++) {

      let pass = false;
      const rule = rules[i];

      let regex = /^@doc\[.+?\]@$/;
      if (!regex.test(rule.s)) {
        return false;
      }

      let propertyGroup = rule.s.replace('@doc', '');
      propertyGroup = propertyGroup.substring(0, propertyGroup.length - 1);
      const value = self.queryHelper._getValue(doc, propertyGroup);

      switch (rule.p) {
        case 'is_not_empty':
          if (value instanceof Array) {
            pass = value.length > 0;
          } else {
            pass = value !== '' && value !== undefined && value !== null;
          }
          break;
        case 'exists':
          pass = typeof value !== 'undefined';
          break;
        case 'is_an_array':
          pass = self.queryHelper._getValue(doc, propertyGroup) instanceof Array;
          break;
        case 'length_greater_than':
          const expected = parseInt(rule.v);
          pass = value.length && value.length > expected;
          break;
        case 'matches':
          regex = new RegExp(rule.v);
          pass = regex.test(value);
          break;
        default:
      }

      if (pass !== true) {
        return false;
      }
    }

    // all the rules passed return true
    return true;
  });
};

module.exports = RulesHelper;
