'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = initRegistry;

var _registry = require('./model/registry');

var _registry2 = _interopRequireDefault(_registry);

var _builtin = require('./model/builtin');

var _builtin2 = _interopRequireDefault(_builtin);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Adds builtin types to a new TypeRegistry and returns it.
 *
 * @param {Server} server - A Server instance.
 * @return {TypeRegistry} a TypeRegistry instance.
 */
function initRegistry(server) {

  const registry = new _registry2.default(server);

  for (const typeName of _builtin2.default) {
    const filename = typeName.replace(/-/g, '');
    const ModelClass = require(`./model/builtin/${filename}`);
    registry.set(typeName, new ModelClass(server));
  }

  return registry;
}
module.exports = exports['default'];
