'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _joi = require('joi');

var _joi2 = _interopRequireDefault(_joi);

var _model = require('../model');

var _model2 = _interopRequireDefault(_model);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Model for datasource objects.
 */
class DatasourceModel extends _model2.default {

  constructor(server) {
    const schema = _joi2.default.object().keys({
      title: _joi2.default.string(),
      description: _joi2.default.string(),
      datasourceType: _joi2.default.string(),
      datasourceParams: _joi2.default.object(),
      version: _joi2.default.number().integer(),
      kibanaSavedObjectMeta: _joi2.default.object().keys({
        searchSourceJSON: _joi2.default.string()
      })
    });

    super(server, 'datasource', schema, 'External datasource');
  }

  _prepare(body) {
    super._prepare(body);
    // kibi: if we don't have this plugin let's not throw exception here and silently fail
    if (this._server.plugins.query_engine) {
      const cryptoHelper = this._server.plugins.query_engine.getCryptoHelper();
      cryptoHelper.encryptDatasourceParams(this._config, body);
    }
  }

}
exports.default = DatasourceModel;
module.exports = exports['default'];
