'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _joi = require('joi');

var _joi2 = _interopRequireDefault(_joi);

var _model = require('../model');

var _model2 = _interopRequireDefault(_model);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Model for additional index metadata.
 */
class FingerprintModel extends _model2.default {

  constructor(server) {
    const schema = _joi2.default.object().keys({
      version: _joi2.default.number().integer(),
      json: _joi2.default.string()
    });

    super(server, 'fingerprint', schema, 'Additional Index Metadata');
  }

}
exports.default = FingerprintModel;
module.exports = exports['default'];
