'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _joi = require('joi');

var _joi2 = _interopRequireDefault(_joi);

var _model = require('../model');

var _model2 = _interopRequireDefault(_model);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Model for index pattern objects.
 */
// kibi: kept here only so old migrations can run - ontology object should NOT exist in the system anymore
class OntologyModel extends _model2.default {
  constructor(server) {

    const schema = _joi2.default.object().keys({
      title: _joi2.default.string(),
      model: _joi2.default.string(),
      version: _joi2.default.number().integer()
    });

    super(server, 'ontology-model', schema, 'Ontology Model');
  }
}
exports.default = OntologyModel;
module.exports = exports['default'];
