'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _joi = require('joi');

var _joi2 = _interopRequireDefault(_joi);

var _model = require('../model');

var _model2 = _interopRequireDefault(_model);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Model for relational graph objects.
 */
class RelationalGraph extends _model2.default {
  constructor(server) {

    const schema = _joi2.default.object().keys({
      title: _joi2.default.string(),
      model: _joi2.default.object().default({}),
      version: _joi2.default.number().integer()
    });

    super(server, 'relational-graph', schema, 'Graph Model');
  }
}
exports.default = RelationalGraph;
module.exports = exports['default'];
