'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _joi = require('joi');

var _joi2 = _interopRequireDefault(_joi);

var _model = require('../model');

var _model2 = _interopRequireDefault(_model);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Model for visualization objects.
 */
class VisualizationModel extends _model2.default {
  constructor(server) {

    const schema = _joi2.default.object().keys({
      title: _joi2.default.string(),
      description: _joi2.default.string().default(null),
      visState: _joi2.default.object().default({}),
      uiStateJSON: _joi2.default.string().default(null),
      savedSearchId: _joi2.default.string(),
      version: _joi2.default.number().integer(),
      kibanaSavedObjectMeta: _joi2.default.object().keys({
        searchSourceJSON: _joi2.default.string()
      })
    });

    super(server, 'visualization', schema, 'Visualization');
  }
}
exports.default = VisualizationModel;
module.exports = exports['default'];
