import React from 'react';
import ReactDOM from 'react-dom';
import PropTypes from 'prop-types';
import {
  EuiButton,
  EuiButtonEmpty,
  EuiFieldText,
  EuiForm,
  EuiFormRow,
  EuiModal,
  EuiModalBody,
  EuiModalFooter,
  EuiModalHeader,
  EuiModalHeaderTitle,
  EuiOverlayMask,
} from '@elastic/eui';

export class SaveServices extends React.Component {
  constructor(props) {
    super(props);

    this.state = {
      isModalVisible: true,
      title: this.props.savedObject ? this.props.savedObject.title : ''
    };
  }

  closeModal = (isSaved) => {
    this.setState({ isModalVisible: false });
    if (isSaved) {
      this.props.onConfirm(this.props.savedObject);
    } else {
      this.props.onCancel();
    }
    if (this.props.container) {
      ReactDOM.unmountComponentAtNode(this.props.container);
    }
  }

  closeModalAndSave() {
    this.setState({ isModalVisible: false });
    this.props.savedObject.title = this.props.savedObject.id = this.state.title;
    this.props.savedObject.save()
      .then((id) => {
        this.closeModal(true);
      })
      .catch((error) => {
        this.props.notify.error(error);
        this.closeModal();
      });
  }

  handleChange = (event) => {
    this.setState({ title: event.target.value });
  }

  render() {
    const saveForm = (
      <EuiForm>
        <EuiFormRow
          label='Title'
        >
          <EuiFieldText
            value={this.state.title}
            onChange={this.handleChange}
            data-test-subj="dialog-add-new-title"
          />
        </EuiFormRow>
      </EuiForm>
    );

    let modal;
    if (this.state.isModalVisible) {
      modal = (
        <EuiOverlayMask style="z-index:1000 !important;">
          <EuiModal
            onClose={ () => this.closeModal() }
          >
            <EuiModalHeader>
              <EuiModalHeaderTitle >
                { 'Save ' +  this.props.savedObjectService.type }
              </EuiModalHeaderTitle>
            </EuiModalHeader>

            <EuiModalBody>
              {saveForm}
            </EuiModalBody>

            <EuiModalFooter>
              <EuiButtonEmpty
                onClick={ () => this.closeModal() }
                data-test-subj="dialog-close-btn"
              >
                Cancel
              </EuiButtonEmpty>

              <EuiButton
                onClick={ () => this.closeModalAndSave() }
                fill
                data-test-subj="dialog-save-btn"
              >
                Save
              </EuiButton>
            </EuiModalFooter>
          </EuiModal>
        </EuiOverlayMask>
      );
    }
    return (
      <div>
        {modal}
      </div>
    );
  }
}

SaveServices.propTypes = {
  savedObjectService: PropTypes.object.isRequired,
  savedObject: PropTypes.object.isRequired,
  notify: PropTypes.object,
  onConfirm: PropTypes.func.isRequired,
  onCancel: PropTypes.func.isRequired,
  container: PropTypes.object
};

export function saveServices(savedObjectService, savedObject, notify, onConfirm, onCancel) {
  const container = document.createElement('div');
  const element = (
    <SaveServices savedObjectService={savedObjectService}
      savedObject={savedObject}
      notify={notify}
      onConfirm={onConfirm}
      onCancel={onCancel}
      container={container}
    >
    </SaveServices>
  );
  ReactDOM.render(element, container);
}
