import { uiModules } from 'ui/modules';
import saveTemplate from './save.html';
import saveController from './save';
import openTemplate from './open.html';
import openController from './open';
import style from '../styles/saved_objects_api.less';
import { saveServices } from './component/save_services_react';
import { openServices } from './component/open_services_react';

uiModules
  .get('kibana')
  .service('savedObjectsAPIModals', function (createNotifier) {

    const notify = createNotifier({ location: 'Object Api Service' });

    /**
   * Exposes methods to show modal dialogs to save and open saved objects.
   */
    class ModalService {
      constructor() {
      }

      /**
     * Displays a modal to save the specified @savedObject .
     *
     * @param {Object} savedObjectService - The service that managed saved objects for the type of the specified @savedObject.
     * @param {SavedObject} savedObject - The saved object to save.
     */
      save(savedObjectService, savedObject) {
        return new Promise((resolve, reject) => {
          saveServices(savedObjectService, savedObject, notify, resolve, reject);
        });
      }

      /**
     * Displays a modal to open a saved object.
     *
     * @param {Object} savedObjectService - A saved object service.
     */
      open(savedObjectService) {
        return new Promise((resolve, reject) => {
          openServices(savedObjectService, notify, resolve, reject);
        });
      }
    }

    return new ModalService();
  });
