import { uiModules } from 'ui/modules';
import template from './loading_indicator.html';
import './loading_indicator.less';

let showIndicator = false;

export function showLoadingIndicator(value) {
  showIndicator = value;
};

uiModules
  .get('ui/kibana')
  .directive('kbnLoadingIndicator', function () {
    return {
      restrict: 'E',
      replace: true,
      template,
      link: function ($scope, $el) {
        $scope.isShown = function () {
          return showIndicator;
        };
      }
    };
  });
