import { uiModules } from 'ui/modules';
const module = uiModules.get('kibana');

module.directive('clickOutside', function ($document) {
  return {
    scope: {
      clickOutside: '&'
    },
    restrict: 'A',
    link: function ($scope, $element) {
      function handler(event) {
        if ($scope.clickOutside &&
          // if click on element itself or click on one of its children then do nothing
          !($element[0] === event.target || $element[0].contains(event.target))) {
          $scope.clickOutside();
        }
      }

      $document.on('click', handler);
      $scope.$on('$destroy', () => $document.off('click', handler));
    }
  };
});
