import { uiModules } from 'ui/modules';
const module = uiModules.get('kibana');

const isChrome = !!window.chrome && window.navigator.vendor === 'Google Inc.';

module.directive('inputFocus', function ($timeout) {
  return {
    restrict: 'A',
    link: function ($scope, $elem, attrs) {

      // kibi: we are running firefox for coverage test. Firefox requires more timeout
      if (isChrome) {
        $timeout(function () {
          $elem.focus();
          if (attrs.inputFocus === 'select') $elem.select();
        });
      } else {
        $timeout(function () {
          $elem.focus();
          if (attrs.inputFocus === 'select') $elem.select();
        }, 100);
      }
    }
  };
});
