import './siren_sort_menu.less';
import sortMenuHtml from './siren_sort_menu.html';
import { uiModules } from 'ui/modules';

const module = uiModules.get('app/discover');

module.directive('sirenSortMenu', function () {
  return {
    scope: {
      visible: '=',
      columnName: '=',
      onChangeSortOrder: '=',
      sortOrder: '='
    },
    template: sortMenuHtml,
    controller: function ($scope) {

      $scope.changeSort = function (direction) {
        $scope.sortOrder = [$scope.columnName, direction];
        $scope.onChangeSortOrder($scope.columnName, direction);
      };

      $scope.removeSort = function () {
        $scope.sortOrder = ['_score', 'desc'];
        $scope.onChangeSortOrder('_score', 'desc');
      };
    }
  };
});
