import { each } from 'lodash';
import { coatHelper } from 'ui/kibi/components/dashboards360/coat_helper';

export function getSearchPropertiesForFilters(filters, coat) {
  const filterIconColorsSearchLabel = [];
  each(filters, filter => {
    if (coat && filter.meta._siren && filter.meta._siren.vis) {
      const node = coatHelper.findItemByVisIdAndPanelIndex(coat.items,
        filter.meta._siren.vis.id, filter.meta._siren.vis.panelIndex);
      if (node && node.d && node.d.entity) {
        filterIconColorsSearchLabel.push({
          searchIcon: node.d.entity.icon,
          searchColor: node.d.entity.color,
          searchLabel: node.d.entity.label
        });
      } else {
        filterIconColorsSearchLabel.push({
          searchIcon: null,
          searchColor: null,
          searchLabel: null
        });
      }
    } else {
      filterIconColorsSearchLabel.push({
        searchIcon: null,
        searchColor: null,
        searchLabel: null
      });
    }
  });

  return filterIconColorsSearchLabel;
}
