import _ from 'lodash';
import { coatHelper } from 'ui/kibi/components/dashboards360/coat_helper';

export function FilterBarLibExtractTimeFilterIfFromMainVisualizationProvider(courier, Promise) {
  return Promise.method(function (filters, coatItems) {
    // Do not assume all filters will be on the same index pattern as they might come from diffrent visualizations (dash 360)
    const notTimeFilters = [];
    const timeFilters = [];
    const promises = filters.map(filter => {
      const id = _.get(filter, 'meta.index');
      if (!id) {
        notTimeFilters.push(filter);
        return Promise.resolve();
      }
      return courier.indexPatterns.get(id).then(indexPattern => {
        const key = _.keys(filter.range)[0];
        const timeFieldName = indexPattern.timeFieldName;
        if (timeFieldName && key && timeFieldName === key) {
          // Note:
          // if it is not assigned to coat tree we assume we should act like it would be assigned to main node
          let isMainVisualization = true;
          let useGlobalTimeFilter = true;
          if (coatItems && filter.meta._siren) {
            const node = coatHelper.findItemByVisIdAndPanelIndex(
              coatItems,
              filter.meta._siren.vis.id,
              filter.meta._siren.vis.panelIndex
            );
            if (node) {
              isMainVisualization = node && node.d && node.d.isRoot;
              useGlobalTimeFilter = node && node.d && node.d.entity.useGlobalTimeFilter;
            }
          }

          if (isMainVisualization && useGlobalTimeFilter) {
            timeFilters.push(filter);
          } else {
            notTimeFilters.push(filter);
          }
        } else {
          notTimeFilters.push(filter);
        }

        return Promise.resolve();
      });
    });

    return Promise.all(promises).then(() => {
      return {
        timeFilters: timeFilters.length > 0 ? timeFilters : undefined,
        notTimeFilters: notTimeFilters.length > 0 ? notTimeFilters : undefined
      };
    });
  });
}
