import { keys } from 'lodash';
import { FilterMetaPropertyIndexError, FilterMetaPropertyKeyError } from 'ui/errors';

export function FilterBarLibMapGeoBoundingBoxProvider(Promise, courier) {
  return function (filter) {
    if (filter.geo_bounding_box) {
      return courier
        .indexPatterns
        .get(filter.meta.index).then(function (indexPattern) {
          const type = 'geo_bounding_box';
          const key = keys(filter.geo_bounding_box)
            .filter(key => key !== 'ignore_unmapped')[0];
          // kibi: handle case where fields are not present (indexPattern no longer exists);
          if (!indexPattern.fields) {
            return Promise.reject(new FilterMetaPropertyIndexError(filter.meta.index));
          }
          // kibi: end
          const field = indexPattern.fields.byName[key];
          // kibi: handle case where the field is no longer present in the index-pattern
          if (!field) {
            return Promise.reject(new FilterMetaPropertyKeyError(key, filter.meta.index));
          }
          // kibi: end
          const geoBoundingBox = filter.geo_bounding_box[key];
          const topLeft = field.format.convert(geoBoundingBox.top_left);
          const bottomRight = field.format.convert(geoBoundingBox.bottom_right);
          const value = topLeft + ' to ' + bottomRight;
          return { type, key, value };
        })
        .catch(err => {
          if (err instanceof FilterMetaPropertyIndexError || err instanceof FilterMetaPropertyKeyError) {
            return Promise.reject(err);
          }
          Promise.reject(new FilterMetaPropertyIndexError(filter.meta.index));
        });
    }
    return Promise.reject(filter);
  };
}
