import { uiModules } from 'ui/modules';
const module = uiModules.get('kibana');

module.filter('escapeHtml', function () {
  const entityMap = {
    '&': '&amp;',
    '<': '&lt;',
    '>': '&gt;',
    '"': '&quot;',
    "'": '&#39;',
    '/': '&#x2F;'
  };

  return str => String(str).replace(/[&<>"'\/]/g, s => entityMap[s]);
});
