import _ from 'lodash';
import angular from 'angular';
import { getHighlightHtml } from 'ui/highlight';

export function IndexPatternsFieldFormatContentTypesProvider() {

  const types = {
    html: function (format, convert) {
      function recurse(value, field, hit, meta) {
        if (value == null) {
          return _.asPrettyString(value);
        }

        if (!value || typeof value.map !== 'function') {
          return convert.call(format, value, field, hit, meta);
        }

        const subVals = value.map(function (v) {
          return recurse(v, field, hit, meta);
        });
        const useMultiLine = subVals.some(function (sub) {
          return sub.indexOf('\n') > -1;
        });

        return subVals.join(',' + (useMultiLine ? '\n' : ' '));
      }

      return function (...args) {
        return `<span ng-non-bindable>${recurse(...args)}</span>`;
      };
    },

    text: function (format, convert) {
      // kibi: mapping was added to make correct label for date fields with custom mapping
      return function recurse(value, mapping) {
        if (!value || typeof value.map !== 'function') {
          return convert.call(format, value, mapping);
        }

        // format a list of values. In text contexts we just use JSON encoding
        /* kibi: value changed to ¨false¨ by us to prevent
           creating of extra lines in CSV´s files with arrays */
        return angular.toJson(value.map(recurse), false);
      };
    }
  };

  function fallbackText(value) {
    return _.asPrettyString(value);
  }

  function fallbackHtml(value, field, hit) {
    const formatted = _.escape(this.convert(value, 'text'));

    if (!hit || !hit.highlight || !hit.highlight[field.name]) {
      return formatted;
    } else {
      return getHighlightHtml(formatted, hit.highlight[field.name]);
    }
  }

  function setup(format) {
    const src = format._convert || {};
    const converters = format._convert = {};

    converters.text = types.text(format, src.text || fallbackText);
    converters.html = types.html(format, src.html || fallbackHtml);

    return format._convert;
  }

  return {
    types: types,
    setup: setup
  };
}
