import _ from 'lodash';
import { Notifier } from 'ui/notify/notifier';
// kibi: IndexPatternAuthorizationError is added
import { NoDefaultIndexPattern } from 'ui/errors';
import loadDefaultIndexPattern from './load_default_index_pattern';
import uiRoutes from 'ui/routes';

const notify = new Notifier({
  location: 'Index Patterns'
});

module.exports = function (opts) {
  opts = opts || {};
  const whenMissingRedirectTo = opts.whenMissingRedirectTo || null;
  let defaultRequiredToasts = [];

  uiRoutes
    .addSetupWork(loadDefaultIndexPattern)
    .afterWork(
    // success
      null,

      // failure
      function (err, kbnUrl) {
      // kibi: if there is a failure, notify the error and redirect
        kbnUrl.change(whenMissingRedirectTo);

        if (!defaultRequiredToasts) defaultRequiredToasts = [];
        else if (!(err instanceof NoDefaultIndexPattern)) defaultRequiredToasts.push(notify.error(err));
      }
    );


};
