import { EntityType } from 'ui/kibi/components/ontology/entity_type';

function findVis(widgets, visId, panelIndex) {
  for (const vis of widgets) {
    if (vis.id === visId && vis.panelIndex === panelIndex) {
      return vis;
    }
  }
}

export function findItemByVisIdAndPanelIndex(items, visId, panelIndex) {
  if (!items) {
    return null;
  }
  for (const item of items) {
    if (item.d && item.d.entity && item.d.entity.type === EntityType.SAVED_SEARCH && item.d.widgets && item.d.widgets.length > 0) {
      const foundVis = findVis(item.d.widgets, visId, panelIndex);
      if (foundVis) {
        return item;
      }
    }
  }
  return null;
}
