export function isVisPresentInTheCoat(_siren) {
  if (!_siren || !_siren.coat || !_siren.coat.items) {
    return false;
  }

  const id = _siren.vis.id;
  const panelIndex = _siren.vis.panelIndex;

  for (const item of _siren.coat.items) {
    if (item.type === 'node' && item.d && item.d.widgets) {
      for (const vis of item.d.widgets) {
        if (vis.id === id && vis.panelIndex === panelIndex) {
          return true;
        }
      }
    }
  }
  return false;
}
