import { findMainNode } from '../find_main_node';
import { findItemByVisIdAndPanelIndex } from '../coat/find_item_by_vis_id_and_panel_index';

export function getMainForThisRequest(mainFilters, _sirenFromVis) {
  if (_sirenFromVis && _sirenFromVis.coat && _sirenFromVis.coat.items && _sirenFromVis.coat.items.length > 0 && _sirenFromVis.coat.node) {
    // if this vis is on the main node - the one assigned on this node, plus the one without meta
    // if this vis is not the main node - the one assigned on the node ONLY
    const mainNode = findMainNode(_sirenFromVis.coat.items);
    return mainFilters.filter(f => {
      if (f.meta && f.meta._siren && f.meta._siren.vis && f.meta._siren.vis.id && f.meta._siren.vis.panelIndex) {
        // get filter node
        const fnode = findItemByVisIdAndPanelIndex(
          _sirenFromVis.coat.items,
          f.meta._siren.vis.id,
          f.meta._siren.vis.panelIndex
        );
        return fnode && fnode.id === _sirenFromVis.coat.node.id;
      } else {
        return mainNode.id === _sirenFromVis.coat.node.id;
      }
    });
  }
  return mainFilters;
}
