import { filter, find, cloneDeep, isEmpty } from 'lodash';

function getInvertedLink(link) {
  const newLink = cloneDeep(link);
  newLink.id = newLink.id + '-inv';
  // reverse id
  const tempId2 = newLink.id2;
  newLink.id2 = newLink.id1;
  newLink.id1 = tempId2;
  // reverse relation
  const tempRel = newLink.d.rel;
  newLink.d.rel = newLink.d.inverseRel;
  newLink.d.inverseRel = tempRel;
  return newLink;
}

function processNode(newTree, treeItems, visitedNodeIds, node) {
  newTree.push(cloneDeep(node));
  visitedNodeIds.push(node.id);

  // process incoming links first
  const inLinks = filter(treeItems, item => {
    return item.type === 'link' && item.id2 === node.id;
  });

  for (const inLink of inLinks) {
    const connectedNode = find(treeItems, item => {
      return item.type === 'node' && item.id === inLink.id1;
    });
    if (visitedNodeIds.indexOf(connectedNode.id) === -1) {
      newTree.push(cloneDeep(inLink));
      processNode(newTree, treeItems, visitedNodeIds, connectedNode);
    }
  }

  // process outgoing links
  const outLinks = filter(treeItems, item => {
    return item.type === 'link' && item.id1 === node.id;
  });

  for (const outLink of outLinks) {
    const connectedNode = find(treeItems, item => {
      return item.type === 'node' && item.id === outLink.id2;
    });
    if (visitedNodeIds.indexOf(connectedNode.id) === -1) {
      const newInLink = getInvertedLink(outLink);
      newTree.push(newInLink);
      processNode(newTree, treeItems, visitedNodeIds, connectedNode);
    }

  }
}

// rotates tree
// Example the below tree have a focus (root) node A and all links are directed down
//
//      A*
//      |
//      ↓
//      B
//     / \
//    ↙   ↘
//   C     D
//
// The same tree focuused on C
//
//      C*
//      ↑
//      |
//      B
//     ↗ ↖
//    /   \
//   A     D
//
// The same tree focuused on D
//
//      D*
//      ↑
//      |
//      B
//     ↗ ↖
//    /   \
//   A     C
//
// The same tree focused to B
//
//       B*
//     ↗ ↑ ↖
//    /  |  \
//   C   A   D
//
export function rotateTree(treeItems, focusNodeId) {
  const newTree = [];
  const visitedNodeIds = [];
  const focusNode = find(treeItems, item => {
    return item.type === 'node' && item.id === focusNodeId;
  });

  processNode(newTree, treeItems, visitedNodeIds, focusNode);
  // first node is root lets make sure that is reflected in d.isRoot property
  if (newTree.length > 0) {
    if (!newTree[0].d) {
      newTree[0].d = {};
    }
    newTree[0].d.isFocused = true;
  }

  return newTree;
}
