import _ from 'lodash';
import { uiModules } from 'ui/modules';
import { OntologyModelSimpleProvider } from 'ui/kibi/components/ontology_model/impl/ontology_model_simple';

class OntologyModel {
  constructor(notify, ontologyModel) {
    this.notify = notify;
    this.ontologyModel = ontologyModel;
  }

  // TODO: we'll add a cache later, given we have the freeze function.

  // Return a list of entities. The list is freezed with Object.freeze, that means it cannot be modified.
  getEntityList() {
    return this.ontologyModel.getEntityList()
      .then(entityList => {
        return entityList;
      })
      .catch(this.notify.error);
  };

  // Return a map of entities <entityId, entity>. The map is freezed with Object.freeze, that means it cannot be modified.
  getEntityMap() {
    return this.ontologyModel.getEntityMap()
      .then(entityMap => {
        return entityMap;
      })
      .catch(this.notify.error);
  };

  // Return a list of relations. The list is freezed with Object.freeze, that means it cannot be modified.
  getRelationList() {
    return this.ontologyModel.getRelationList()
      .then(relationList => {
        return relationList;
      })
      .catch(this.notify.error);
  }

  // Return a map of relations <relationId, relation>. The map is freezed with Object.freeze, that means it cannot be modified.
  getRelationMap() {
    return this.ontologyModel.getRelationMap()
      .then(relationMap => {
        return relationMap;
      })
      .catch(this.notify.error);
  };

  // Return a list of relations having the passed entity as domain.
  getRelationsByDomain(entityId) {
    return this.ontologyModel.getRelationsByDomain(entityId)
      .then(relationsByDomain => {
        return relationsByDomain;
      })
      .catch(this.notify.error);
  };

  // Returns the list of relation labels (unique values)
  getUniqueRelationLabels() {
    return this.ontologyModel.getUniqueRelationLabels()
      .then(uniqueRelationLabels => {
        return uniqueRelationLabels;
      })
      .catch(this.notify.error);
  };

  //Returns the list of relation label pairs (unique values)
  getUniqueRelationLabelPairs() {
    return this.ontologyModel.getUniqueRelationLabelPairs()
      .then(uniqueRelationLabelPairs => {
        return uniqueRelationLabelPairs;
      })
      .catch(this.notify.error);
  };

  // Returns a list of ranges for a given entity id.
  getRangesForEntityId(entityId) {
    return this.ontologyModel.getRangesForEntityId(entityId)
      .then(ranges => {
        return ranges;
      })
      .catch(this.notify.error);
  }

  // Returns all the aggregatable paths
  getAllPaths() {
    return this.ontologyModel.getAllPaths()
      .then(paths => {
        return paths;
      })
      .catch(this.notify.error);
  }

  // clears the current caches
  clearCache() {
    return this.ontologyModel.clearCache();
  }

  getBrokenSavedSearches() {
    return this.ontologyModel.getBrokenSavedSearches();
  }
}

uiModules
  .get('kibana/ontology_model')
  .service('ontologyModel', function (Private, createNotifier) {
    const notify = createNotifier({
      location: 'Siren Ontology Model'
    });

    const ontologyModel = Private(OntologyModelSimpleProvider);

    return new OntologyModel(notify, ontologyModel);
  });
