export function fitSizeToContainerWithOptsHelper({
  elementWidth,
  elementHeight,
  containerWidth,
  containerHeight,
  adjustableProportion,
  sizeProportion
}) {
  const IMG_PROPORTION = elementWidth / elementHeight;

  const fittedSize = {};
  if (elementWidth > containerWidth && elementHeight > containerHeight) {
    if (elementWidth / sizeProportion > containerHeight) {
      if (containerHeight * IMG_PROPORTION > containerWidth) {
        fittedSize.width = containerWidth;
        fittedSize.height = fittedSize.width / IMG_PROPORTION;
      } else {
        fittedSize.height = containerHeight * adjustableProportion;
        fittedSize.width = fittedSize.height * IMG_PROPORTION;
      };
    } else {
      fittedSize.width = containerWidth;
      fittedSize.height = fittedSize.width / IMG_PROPORTION;
    };
  } else if (elementWidth > containerWidth) {
    fittedSize.width = containerWidth;
    fittedSize.height = fittedSize.width / IMG_PROPORTION;
  } else if (elementHeight > containerHeight) {
    fittedSize.height = containerHeight * adjustableProportion;
    fittedSize.width = fittedSize.height * IMG_PROPORTION;
  } else {
    fittedSize.width = elementWidth * adjustableProportion;
    fittedSize.height = fittedSize.width / IMG_PROPORTION;
  };

  fittedSize.width = Math.round(fittedSize.width);
  fittedSize.height = Math.round(fittedSize.height);

  return fittedSize;
};
