
import messageBoxTemplate from './message_box.html';
import './message_box.less';

import { BaseModalProvider } from './base_modal';

import _ from 'lodash';


export function MessageBoxProvider(Private) {
  const baseModal = Private(BaseModalProvider);

  return function messageBox(opts) {
    opts = _.assign({
      title: '',
      content: '',
      buttons: []
    }, opts);

    if (!opts.buttons.length) { opts.buttons = ['Ok']; }

    const template = messageBoxTemplate.replace('[[content]]', opts.content);
    return baseModal(template, opts);
  };
}
