import template from './kibi_relation_explorer.html';

import './kibi_termsx.less';
import '../layout.less';

import 'ui/doc_viewer/doc_viewer';

import { uiModules } from 'ui/modules';


function hitName(hit, name) {
  if (!hit || hit._source[name]) { return name; }

  // Multifields or, in general, fields that are not stored in the source could
  // be specified. In that case, remove everything after the dot and retry

  const dotPos = name.indexOf('.');
  return name.substring(0, dotPos < 0 ? name.length : dotPos);
};

uiModules
  .get('kibana')
  .directive('kibiRelationExplorer', function () {
    return {
      restrict: 'E',
      scope: {
        direction: '=',

        leftField: '=',
        leftText: '=',

        rightField: '=',
        rightText: '=',

        docMode: '=',
        docTerm: '=',
        doc: '='
      },
      template,
      controller($scope) {
        Object.defineProperty($scope, 'docRepeat', {
          get() { return this.doc ? [ this.doc ] : []; }
        });

        this.leftHitName = hitName($scope.doc.left, $scope.leftField.name);
        this.rightHitName = hitName($scope.doc.right, $scope.rightField.name);

        $scope.highlightLeftField = (fieldName) => ({
          'kibi-findrel-highlighted': fieldName === this.leftHitName
        });

        $scope.highlightRightField = (fieldName) => ({
          'kibi-findrel-highlighted': fieldName === this.rightHitName
        });
      }
    };
  });
