import template from './kibi_terms_explorer.html';

import './kibi_termsx.less';
import '../layout.less';

import 'ui/doc_viewer/doc_viewer';

import { uiModules } from 'ui/modules';


function hitName(hit, name) {
  if (!hit || hit._source[name]) { return name; }

  // Multifields or, in general, fields that are not stored in the source could
  // be specified. In that case, remove everything after the dot and retry

  const dotPos = name.indexOf('.');
  return name.substring(0, dotPos < 0 ? name.length : dotPos);
};


uiModules
  .get('kibana')
  .directive('kibiTermsExplorer', function () {
    return {
      restrict: 'E',
      scope: {
        field: '=',
        fieldText: '=',

        docMode: '=',
        docTerm: '=',
        doc: '='
      },
      template,
      controller($scope) {
        Object.defineProperty($scope, 'docRepeat', {
          get() { return this.doc ? [ this.doc ] : []; }
        });

        this.fieldHitName = hitName($scope.doc.value, $scope.field.name);

        $scope.highlightField = (fieldName) => ({
          'kibi-findrel-highlighted': fieldName === this.fieldHitName
        });
      }
    };
  });

