import { uiModules } from 'ui/modules';
import { once, clone, get } from 'lodash';

import toggleHtml from './kbn_global_timepicker.html';
import './kbn_global_timepicker.less';
import { timeNavigation } from './time_navigation';
import { findMainCoatNodeSearchId } from 'ui/kibi/components/dashboards360/coat_tree';

uiModules
  .get('kibana')
  .directive('kbnGlobalTimepicker', (timefilter, globalState, $rootScope, kibiState) => {
    const listenForUpdates = once($scope => {
      $scope.$listen(timefilter, 'update', () => {
        globalState.time = clone(timefilter.time);
        globalState.refreshInterval = clone(timefilter.refreshInterval);
        globalState.save();
      });
    });

    return {
      template: toggleHtml,
      replace: true,
      link: ($scope, element, attributes) => {
        listenForUpdates($rootScope);

        // kibi: added to display a tooltip
        const dash = kibiState.getDashboardOnView();
        if (dash) {
          const timeField = get(dash, 'indexPattern.timeFieldName');
          $scope.timeRangeTooltip = timeField ? `Time range applied to field '${timeField}'` : 'Time range applied to all visualizations';
        }
        // kibi: end

        $rootScope.timefilter = timefilter;

        $rootScope.toggleRefresh = () => {
          timefilter.refreshInterval.pause = !timefilter.refreshInterval.pause;
        };

        $scope.forward = function () {
          timefilter.time = timeNavigation.stepForward(timefilter.getBounds());
        };

        $scope.back = function () {
          timefilter.time = timeNavigation.stepBackward(timefilter.getBounds());
        };

        $scope.zoomIn = function () {
          timefilter.time = timeNavigation.zoomIn(timefilter.getBounds());
        };

        $scope.zoomOut = function () {
          timefilter.time = timeNavigation.zoomOut(timefilter.getBounds());
        };

        $scope.updateFilter = function (from, to) {
          timefilter.time.from = from;
          timefilter.time.to = to;
          $scope.kbnTopNav.close('filter');
        };

        $scope.updateInterval = function (interval) {
          timefilter.refreshInterval = interval;
          $scope.kbnTopNav.close('interval');
        };
      },
    };
  });
