import serverRoute from './server/routes/routing';
import { registerV1APIs } from './server/api/v1';

export default function IngestPluginFactory(kibana) {
  const xlsxHostPath = '/xlsx/lib/';
  const apiBasePath = '/ingest/api/';
  const xlsxApiPath = `${apiBasePath}xlsx_import/`;
  const XLSX_CONFIG_INDEX = '.siren-excel-configs';
  return new kibana.Plugin({
    name: 'ingest',
    require: ['elasticsearch', 'kibana'],

    config: function (Joi) {
      return Joi.object({
        enabled: Joi.boolean().default(true)
      });
    },

    init: function (server) {
      const config = server.config();

      const configObject = config.get('ingest');
      if (!configObject || !configObject.enabled) {
        return;
      }
    },

    uiExports: {
      hacks: [
        'plugins/ingest/services'
      ],
      apps: [{
        id: 'ingest',
        main: 'plugins/ingest/app.js',
        icon: 'plugins/ingest/icon.svg',
        title: 'Data Reflections',
        url: '/app/ingest#/home',
      }],
      uiSettingDefaults: {
        'ingest-xlsx:bulk_package_size': {
          value: 1000,
          description: 'The number of documents sent per bulk request.'
        },
        'ingest-xlsx:displayed_rows': {
          value: 5,
          description: 'Number of rows displayed in the preview.'
        },
        'ingest-xlsx:simultaneous_bulk_requests': {
          value: 5,
          description: 'Tune how many simultaneous bulk requests you wish to send.'
        },
        'ingest-xlsx:progress_updation_frequency': {
          value: 5,
          description: 'How often you wish to see the progress bar updated (0 => everytime, 5 => ' +
            'after every 5 requests), frequent updating may reduce the ingestion rate.'
        }
      },
      injectDefaultVars(server, options) {
        options.xlsxHostPath = xlsxHostPath;
        options.apiBasePath = apiBasePath;
        options.xlsxApiPath = xlsxApiPath;
        options.jobPageRefresh = 5000;
        return options;
      }
    },

    init(server) {
      const dataCluster = server.plugins.elasticsearch.getCluster('data');

      serverRoute(server, dataCluster, XLSX_CONFIG_INDEX, xlsxApiPath);
      registerV1APIs(server, dataCluster, apiBasePath);
      require('./server/host')(server, xlsxHostPath);
    }
  });
}
