## Contributing to react-router-navigation-prompt

### Reporting bugs

  - Please post any relevant code samples, preferably a standalone script that
  reproduces your issue. Do **not** describe your issue in prose, show your
  code.
  - If the bug involves an error, please post the stack trace.
  - Please post the output of `npm list react react-router react-router-dom react-router-navigation-prompt` (with redactions if needed).
  - Please write bug reports in JavaScript, not coffeescript, typescript, etc.

### Requesting new features

- Please describe a use case for it
- it would be ideal to include test cases as well

### Pull Request Process

Accompanying tests are great, but not necessary.
Flow updates are great, but not necessary.

1. Ensure `npm run build` was run.
2. Ensure `npm run lint; npm run test` passed (a passing `npm run flow` is a bonus - I can fix any errors there).
3. Update the README.md with details of changes to the interface
4. Increase the version numbers in package.json. The versioning scheme we use is [SemVer](http://semver.org/).
